<?php
/**
 * Plugin Name: E'Nibbles Get Demo Button
 * Description: Adds a 'Get Demo' button with media upload option on WooCommerce product pages.
 * Version: 1.0
 * Author: Exam Nibbles
 * License: GPL2
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// Add custom field in product edit page
add_action( 'woocommerce_product_options_general_product_data', 'en_add_demo_file_field' );
function en_add_demo_file_field() {
    echo '<div class="options_group">';
    woocommerce_wp_text_input( array(
        'id'          => '_en_demo_file_url',
        'label'       => __( 'Demo File URL', 'en-demo' ),
        'desc_tip'    => true,
        'description' => __( 'Upload or paste the demo file URL (PDF, ZIP, etc.).', 'en-demo' ),
    ) );
    echo '</div>';
    ?>
    <script>
    jQuery(function($){
        var mediaUploader;
        var field = $('#_en_demo_file_url');
        var button = $('<button type="button" class="button upload_demo_file">Upload Demo File</button>');
        field.after(button);
        button.on('click', function(e){
            e.preventDefault();
            if(mediaUploader){
                mediaUploader.open();
                return;
            }
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Choose Demo File',
                button: { text: 'Select File' },
                multiple: false
            });
            mediaUploader.on('select', function(){
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                field.val(attachment.url);
            });
            mediaUploader.open();
        });
    });
    </script>
    <?php
}

// Save the field
add_action( 'woocommerce_admin_process_product_object', 'en_save_demo_file_field' );
function en_save_demo_file_field( $product ) {
    if ( isset( $_POST['_en_demo_file_url'] ) ) {
        $product->update_meta_data( '_en_demo_file_url', esc_url_raw( $_POST['_en_demo_file_url'] ) );
    }
}

// Display Get Demo button on frontend
add_action( 'woocommerce_before_add_to_cart_button', 'en_display_get_demo_button', 9 );
function en_display_get_demo_button() {
    global $product;
    $demo_file = get_post_meta( $product->get_id(), '_en_demo_file_url', true );
    if ( ! empty( $demo_file ) ) {
        echo '<a href="' . esc_url( $demo_file ) . '" class="en-get-demo-btn" target="_blank">📂 Get Demo</a>';
    }
}

// Add frontend styles
add_action( 'wp_head', function(){
    echo '<style>
    .en-get-demo-btn {
        background-color: #f0f6ff;
        border: 1px solid #0073aa;
        color: #0073aa;
        padding: 10px 18px;
        border-radius: 6px;
        width: 100%;
        margin-bottom: 10px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        text-decoration: none;
    }
    .en-get-demo-btn:hover {
        background-color: #0073aa;
        color: #fff;
    }
    </style>';
});
